implementation module windowclipstate


//	Clean Object I/O library, version 1.0.1

import StdBool, StdInt, StdMisc
import osrgn, oswindow
import windowaccess, wstateaccess


createClipState :: !OSWindowPtr !Point !Rect !(Maybe Id) ![WElementHandle .ls .ps] !*OSToolbox -> (!ClipState,![WElementHandle .ls .ps],!*OSToolbox)
createClipState wPtr parentPos=:{x,y} clipRect=:(l,t,r,b) defId itemHs tb
	# (clipRgn,tb)			= osnewrgn tb
	# (clipRgn,tb)			= osrectrgn (l-x,t-y,r-x,b-y) clipRgn tb
	# (itemHs,clipRgn,tb)	= createWElementsClipState wPtr parentPos clipRect defId itemHs clipRgn tb
	= ({clipRgn=clipRgn,clipOk=True},itemHs,tb)
where
	createWElementsClipState :: !OSWindowPtr !Point !Rect !(Maybe Id) ![WElementHandle .ls .ps] !OSRgnHandle !*OSToolbox
																  -> (![WElementHandle .ls .ps],!OSRgnHandle,!*OSToolbox)
	createWElementsClipState wPtr parentPos clipRect defId [itemH:itemHs] clipRgn tb
		# (itemH, clipRgn,tb)	= createWElementClipState  wPtr parentPos clipRect defId itemH  clipRgn tb
		# (itemHs,clipRgn,tb)	= createWElementsClipState wPtr parentPos clipRect defId itemHs clipRgn tb
		= ([itemH:itemHs],clipRgn,tb)
	where
		createWElementClipState :: !OSWindowPtr !Point !Rect !(Maybe Id) !(WElementHandle .ls .ps) !OSRgnHandle !*OSToolbox
																	  -> (!WElementHandle .ls .ps, !OSRgnHandle,!*OSToolbox)
		createWElementClipState wPtr parentPos clipRect defId (WListLSHandle itemHs) clipRgn tb
			# (itemHs,clipRgn,tb)	= createWElementsClipState wPtr parentPos clipRect defId itemHs clipRgn tb
			= (WListLSHandle itemHs,clipRgn,tb)
		createWElementClipState wPtr parentPos clipRect defId (WExtendLSHandle wExH=:{wExtendItems=itemHs}) clipRgn tb
			# (itemHs,clipRgn,tb)	= createWElementsClipState wPtr parentPos clipRect defId itemHs clipRgn tb
			= (WExtendLSHandle {wExH & wExtendItems=itemHs},clipRgn,tb)
		createWElementClipState wPtr parentPos clipRect defId (WChangeLSHandle wChH=:{wChangeItems=itemHs}) clipRgn tb
			# (itemHs,clipRgn,tb)	= createWElementsClipState wPtr parentPos clipRect defId itemHs clipRgn tb
			= (WChangeLSHandle {wChH & wChangeItems=itemHs},clipRgn,tb)
		createWElementClipState wPtr parentPos clipRect defId (WItemHandle itemH=:{wItemShow,wItemPos,wItemSize}) clipRgn tb
			| not wItemShow || DisjointRects clipRect (PosSizeToRect wItemPos wItemSize)
				= (WItemHandle itemH,clipRgn,tb)
			# (itemH,clipRgn,tb)	= createWItemClipState wPtr parentPos clipRect defId itemH clipRgn tb
			// otherwise
			= (WItemHandle itemH,clipRgn,tb)
		where
			createWItemClipState :: !OSWindowPtr !Point !Rect !(Maybe Id) !(WItemHandle .ls .ps) !OSRgnHandle !*OSToolbox
																	   -> (!WItemHandle .ls .ps, !OSRgnHandle,!*OSToolbox)
			createWItemClipState wPtr parentPos clipRect _ itemH=:{wItemKind=IsRadioControl,wItemInfo} clipRgn tb
				# (clipRgn,tb)	= StateMap2 (createRadioClipState wPtr parentPos clipRect) (getWItemRadioInfo wItemInfo).radioItems (clipRgn,tb)
				= (itemH,clipRgn,tb)
			where
				createRadioClipState :: !OSWindowPtr !Point !Rect !(RadioItemInfo .ps) !(!OSRgnHandle,!*OSToolbox) -> (!OSRgnHandle,!*OSToolbox)
				createRadioClipState wPtr parentPos clipRect {radioItemPos,radioItemSize} (clipRgn,tb)
					# (radioRgn,tb)	= OSclipRadioControl wPtr (PointToTuple parentPos) clipRect (PointToTuple radioItemPos) (SizeToTuple radioItemSize) tb
					# (diffRgn, tb)	= osdiffrgn clipRgn radioRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn radioRgn tb
					= (diffRgn,tb)
			
			createWItemClipState wPtr parentPos clipRect defId itemH=:{wItemKind=IsCheckControl,wItemInfo} clipRgn tb
				# (clipRgn,tb)	= StateMap2 (createCheckClipState wPtr parentPos clipRect) (getWItemCheckInfo wItemInfo).checkItems (clipRgn,tb)
				= (itemH,clipRgn,tb)
			where
				createCheckClipState :: !OSWindowPtr !Point !Rect !(CheckItemInfo .ps) !(!OSRgnHandle,!*OSToolbox) -> (!OSRgnHandle,!*OSToolbox)
				createCheckClipState wPtr parentPos clipRect {checkItemPos,checkItemSize} (clipRgn,tb)
					# (checkRgn,tb)	= OSclipCheckControl wPtr (PointToTuple parentPos) clipRect (PointToTuple checkItemPos) (SizeToTuple checkItemSize) tb
					# (diffRgn, tb)	= osdiffrgn clipRgn checkRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn checkRgn tb
					= (diffRgn,tb)
			
			createWItemClipState wPtr parentPos clipRect defId itemH=:{wItemKind=IsCompoundControl,wItemInfo,wItems,wItemPos,wItemSize} clipRgn tb
				| isTransparent
					# (itemHs,clipRgn,tb)
									= createWElementsClipState wPtr wItemPos clipRect1 defId wItems clipRgn tb
					= ({itemH & wItems=itemHs},clipRgn,tb)
				// otherwise
					# (rectRgn,tb)	= OSclipCompoundControl wPtr (PointToTuple parentPos) clipRect (PointToTuple wItemPos) (SizeToTuple wItemSize) tb
					# (diffRgn,tb)	= osdiffrgn clipRgn rectRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn rectRgn tb
					= (itemH,diffRgn,tb)
			where
				info				= getWItemCompoundInfo wItemInfo
				isTransparent		= isNothing info.compoundLookInfo
				clipRect1			= IntersectRects clipRect (PosSizeToRect wItemPos wItemSize)
			
			createWItemClipState wPtr parentPos clipRect defId itemH=:{wItemKind,wItemPos,wItemSize} clipRgn tb
				| okItem
					# (itemRgn,tb)	= clipItem wPtr (PointToTuple parentPos) clipRect (PointToTuple wItemPos) (SizeToTuple wItemSize) tb
					# (diffRgn,tb)	= osdiffrgn clipRgn itemRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn itemRgn tb
					= (itemH,diffRgn,tb)
			where
				(okItem,clipItem)	= case wItemKind of
										IsPopUpControl			-> (True,OSclipPopUpControl)
										IsSliderControl			-> (True,OSclipSliderControl)
										IsTextControl			-> (True,OSclipTextControl)
										IsEditControl			-> (True,OSclipEditControl)
										IsButtonControl			-> (True,OSclipButtonControl)
										IsCustomButtonControl	-> (True,OSclipCustomButtonControl)
										IsCustomControl			-> (True,OSclipCustomControl)
										_						-> (False,undef)
				
			createWItemClipState _ _ _ _ itemH clipRgn tb
				= (itemH,clipRgn,tb)
	createWElementsClipState _ _ _ _ itemHs clipRgn tb
		= (itemHs,clipRgn,tb)

createClipState` :: !OSWindowPtr !Point !Rect !(Maybe Id) ![WElementHandle`] !*OSToolbox -> (!ClipState,!*OSToolbox)
createClipState` wPtr parentPos=:{x,y} clipRect=:(l,t,r,b) defId itemHs tb
	# (clipRgn,tb)	= osnewrgn tb
	# (clipRgn,tb)	= osrectrgn (l-x,t-y,r-x,b-y) clipRgn tb
	# (clipRgn,tb)	= createWElementsClipState` wPtr parentPos clipRect defId itemHs clipRgn tb
	= ({clipRgn=clipRgn,clipOk=True},tb)
where
	createWElementsClipState` :: !OSWindowPtr !Point !Rect !(Maybe Id) ![WElementHandle`] !OSRgnHandle !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
	createWElementsClipState` wPtr parentPos clipRect defId [itemH:itemHs] clipRgn tb
		# (clipRgn,tb)	= createWElementClipState`  wPtr parentPos clipRect defId itemH  clipRgn tb
		# (clipRgn,tb)	= createWElementsClipState` wPtr parentPos clipRect defId itemHs clipRgn tb
		= (clipRgn,tb)
	where
		createWElementClipState` :: !OSWindowPtr !Point !Rect !(Maybe Id) !WElementHandle` !OSRgnHandle !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
		createWElementClipState` wPtr parentPos clipRect defId (WRecursiveHandle` itemHs _) clipRgn tb
			= createWElementsClipState` wPtr parentPos clipRect defId itemHs clipRgn tb
		createWElementClipState` wPtr parentPos clipRect defId (WItemHandle` itemH=:{wItemShow`,wItemPos`,wItemSize`}) clipRgn tb
			| not wItemShow` || DisjointRects clipRect (PosSizeToRect wItemPos` wItemSize`)
				= (clipRgn,tb)
				= createWItemClipState` wPtr parentPos clipRect defId itemH clipRgn tb
		where
			createWItemClipState` :: !OSWindowPtr !Point !Rect !(Maybe Id) !WItemHandle` !OSRgnHandle !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)
			createWItemClipState` wPtr parentPos clipRect _ itemH=:{wItemKind`=IsRadioControl,wItemInfo`} clipRgn tb
				= StateMap2 (createRadioClipState` wPtr parentPos clipRect) (getWItemRadioInfo` wItemInfo`).radioItems` (clipRgn,tb)
			where
				createRadioClipState` :: !OSWindowPtr !Point !Rect !RadioItemInfo` !(!OSRgnHandle,!*OSToolbox) -> (!OSRgnHandle,!*OSToolbox)
				createRadioClipState` wPtr parentPos clipRect {radioItemPos`,radioItemSize`} (clipRgn,tb)
					# (radioRgn,tb)	= OSclipRadioControl wPtr (PointToTuple parentPos) clipRect (PointToTuple radioItemPos`) (SizeToTuple radioItemSize`) tb
					# (diffRgn, tb)	= osdiffrgn clipRgn radioRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn radioRgn tb
					= (diffRgn,tb)
			
			createWItemClipState` wPtr parentPos clipRect defId itemH=:{wItemKind`=IsCheckControl,wItemInfo`} clipRgn tb
				= StateMap2 (createCheckClipState` wPtr parentPos clipRect) (getWItemCheckInfo` wItemInfo`).checkItems` (clipRgn,tb)
			where
				createCheckClipState` :: !OSWindowPtr !Point !Rect !CheckItemInfo` !(!OSRgnHandle,!*OSToolbox) -> (!OSRgnHandle,!*OSToolbox)
				createCheckClipState` wPtr parentPos clipRect {checkItemPos`,checkItemSize`} (clipRgn,tb)
					# (checkRgn,tb)	= OSclipCheckControl wPtr (PointToTuple parentPos) clipRect (PointToTuple checkItemPos`) (SizeToTuple checkItemSize`) tb
					# (diffRgn, tb)	= osdiffrgn clipRgn checkRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn checkRgn tb
					= (diffRgn,tb)
			
			createWItemClipState` wPtr parentPos clipRect defId itemH=:{wItemKind`=IsCompoundControl,wItemInfo`,wItems`,wItemPos`,wItemSize`} clipRgn tb
				| isTransparent
					= createWElementsClipState` wPtr wItemPos` clipRect1 defId wItems` clipRgn tb
				// otherwise
					# (rectRgn,tb)	= OSclipCompoundControl wPtr (PointToTuple parentPos) clipRect (PointToTuple wItemPos`) (SizeToTuple wItemSize`) tb
					# (diffRgn,tb)	= osdiffrgn clipRgn rectRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn rectRgn tb
					= (diffRgn,tb)
			where
				info				= getWItemCompoundInfo` wItemInfo`
				isTransparent		= isNothing info.compoundLookInfo
				clipRect1			= IntersectRects clipRect (PosSizeToRect wItemPos` wItemSize`)
			
			createWItemClipState` wPtr parentPos clipRect defId itemH=:{wItemKind`,wItemPos`,wItemSize`} clipRgn tb
				| okItem
					# (itemRgn,tb)	= clipItem wPtr (PointToTuple parentPos) clipRect (PointToTuple wItemPos`) (SizeToTuple wItemSize`) tb
					# (diffRgn,tb)	= osdiffrgn clipRgn itemRgn tb
					# tb			= osdisposergn clipRgn tb
					# tb			= osdisposergn itemRgn tb
					= (diffRgn,tb)
			where
				(okItem,clipItem)	= case wItemKind` of
										IsPopUpControl			-> (True,OSclipPopUpControl)
										IsSliderControl			-> (True,OSclipSliderControl)
										IsTextControl			-> (True,OSclipTextControl)
										IsEditControl			-> (True,OSclipEditControl)
										IsButtonControl			-> (True,OSclipButtonControl)
										IsCustomButtonControl	-> (True,OSclipCustomButtonControl)
										IsCustomControl			-> (True,OSclipCustomControl)
										_						-> (False,undef)
				
			createWItemClipState` _ _ _ _ _ clipRgn tb
				= (clipRgn,tb)
	createWElementsClipState` _ _ _ _ _ clipRgn tb
		= (clipRgn,tb)


disposeClipState:: !ClipState !*OSToolbox -> *OSToolbox
disposeClipState {clipRgn} tb
	| clipRgn==0
	= tb
	= osdisposergn clipRgn tb


validateWindowClipState :: !OSWindowPtr !(WindowHandle .ls .ps) !*OSToolbox -> (!WindowHandle .ls .ps,!*OSToolbox)
validateWindowClipState wPtr wH=:{whWindowInfo,whItems,whSize,whDefaultId} tb
	| isNothing whWindowInfo
	= (wH,tb)
	# windowInfo			= fromJust whWindowInfo
	  clipState				= windowInfo.windowClip
	| clipState.clipOk
	= (wH,tb)
	# tb					= disposeClipState clipState tb
	# (clipState,itemHs,tb)	= createClipState wPtr zero (SizeToRect whSize) whDefaultId whItems tb
	  windowInfo			= {windowInfo & windowClip=clipState}
	= ({wH & whItems=itemHs,whWindowInfo=Just windowInfo},tb)

validateWindowClipState` :: !OSWindowPtr !WindowHandle` !*OSToolbox -> (!WindowHandle`,!*OSToolbox)
validateWindowClipState` wPtr wH=:{whWindowInfo`,whItems`,whSize`,whDefaultId`} tb
	| isNothing whWindowInfo`
	= (wH,tb)
	# windowInfo			= fromJust whWindowInfo`
	  clipState				= windowInfo.windowClip
	| clipState.clipOk
	= (wH,tb)
	# tb					= disposeClipState clipState tb
	# (clipState,tb)		= createClipState` wPtr zero (SizeToRect whSize`) whDefaultId` whItems` tb
	  windowInfo			= {windowInfo & windowClip=clipState}
	= ({wH & whWindowInfo`=Just windowInfo},tb)

invalidateWindowClipState :: !(WindowHandle .ls .ps) -> WindowHandle .ls .ps
invalidateWindowClipState wH=:{whWindowInfo}
	| isNothing whWindowInfo
	= wH
	# windowInfo			= fromJust whWindowInfo
	  clipState				= windowInfo.windowClip
	= {wH & whWindowInfo=Just {windowInfo & windowClip={clipState & clipOk=False}}}

invalidateWindowClipState` :: !WindowHandle` -> WindowHandle`
invalidateWindowClipState` wH=:{whWindowInfo`}
	| isNothing whWindowInfo`
	= wH
	# windowInfo			= fromJust whWindowInfo`
	  clipState				= windowInfo.windowClip
	= {wH & whWindowInfo`=Just {windowInfo & windowClip={clipState & clipOk=False}}}

validateCompoundClipState :: !OSWindowPtr !(Maybe Id) !(WItemHandle .ls .ps) !*OSToolbox -> (!WItemHandle .ls .ps,!*OSToolbox)
validateCompoundClipState wPtr defId itemH=:{wItemPos,wItemSize,wItemInfo,wItems} tb
	# compoundInfo			= getWItemCompoundInfo wItemInfo
	| isNothing compoundInfo.compoundLookInfo
	= (itemH,tb)
	# compoundLook			= fromJust compoundInfo.compoundLookInfo
	  clipState				= compoundLook.compoundClip
	| clipState.clipOk
	= (itemH,tb)
	# tb					= disposeClipState clipState tb
	# (clipState,itemHs,tb)	= createClipState wPtr wItemPos (PosSizeToRect wItemPos wItemSize) defId wItems tb
	  compoundInfo			= {compoundInfo & compoundLookInfo=Just {compoundLook & compoundClip=clipState}}
	= ({itemH & wItemInfo=CompoundInfo compoundInfo,wItems=itemHs},tb)

validateCompoundClipState` :: !OSWindowPtr !(Maybe Id) !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
validateCompoundClipState` wPtr defId itemH=:{wItemPos`,wItemSize`,wItemInfo`,wItems`} tb
	# compoundInfo			= getWItemCompoundInfo` wItemInfo`
	| isNothing compoundInfo.compoundLookInfo
	= (itemH,tb)
	# compoundLook			= fromJust compoundInfo.compoundLookInfo
	  clipState				= compoundLook.compoundClip
	| clipState.clipOk
	= (itemH,tb)
	# tb					= disposeClipState clipState tb
	# (clipState,tb)		= createClipState` wPtr wItemPos` (PosSizeToRect wItemPos` wItemSize`) defId wItems` tb
	  compoundInfo			= {compoundInfo & compoundLookInfo=Just {compoundLook & compoundClip=clipState}}
	= ({itemH & wItemInfo`=CompoundInfo` compoundInfo},tb)

invalidateCompoundClipState :: !(WItemHandle .ls .ps) -> WItemHandle .ls .ps
invalidateCompoundClipState itemH=:{wItemInfo}
	# compoundInfo			= getWItemCompoundInfo wItemInfo
	| isNothing compoundInfo.compoundLookInfo
	= itemH
	# compoundLook			= fromJust compoundInfo.compoundLookInfo
	  clipState				= compoundLook.compoundClip
	= {itemH & wItemInfo=CompoundInfo {compoundInfo & compoundLookInfo=Just {compoundLook & compoundClip={clipState & clipOk=False}}}}

invalidateCompoundClipState` :: !WItemHandle` -> WItemHandle`
invalidateCompoundClipState` itemH=:{wItemInfo`}
	# compoundInfo			= getWItemCompoundInfo` wItemInfo`
	| isNothing compoundInfo.compoundLookInfo
	= itemH
	# compoundLook			= fromJust compoundInfo.compoundLookInfo
	  clipState				= compoundLook.compoundClip
	= {itemH & wItemInfo`=CompoundInfo` {compoundInfo & compoundLookInfo=Just {compoundLook & compoundClip={clipState & clipOk=False}}}}
